/* Random generator of Sensor Placement Problems.

   Written by Enrico Grande. */

#include<iostream>
#include<fstream>
#include<string>
#include<vector> 
#include<iterator>
#include<algorithm> 
#include<stdlib.h>
#include<cmath>
#include<numeric>
#include<math.h>
#include<time.h>
#include<iomanip>
#include <stdio.h>
#include<limits.h>

using namespace std;

/**
 * Implementazione del generatore di Lehmer; genera numeri pseudocasuali con 
 * distribuzione uniforme.
 */

vector<double> lehmer( int q )
{
 int m = INT_MAX;    // 2^(31)-1 --> definita in <limits.h>
 srand( time( 0 ) ); // init generatore casuale
 int init = rand();
 double n;
 double Z = init;    // numero scelto per iniziare la serie
 int ESTREMO = 1;
 double z;           //numero pseuocasuale compreso tra 0 e ESTREMO
 int iter = 0; 
 int MAX_ITER = q;
 vector<double> rand_num( q );
 // ciclo di generazione numeri
 while( iter < MAX_ITER) {
  n = init * Z;
  Z = fmod( n , m );
  z = ( Z / m ) * ESTREMO;
  rand_num[ iter++ ] = z;
  }    

 return( rand_num );
 }

/**
 * Implementazione del generatore di Box-muller; genera numeri pseudocasuali con 
 * distribuzione normale.
 */

#define Pi 3.14159265

vector<double> boxmuller( int qq , double m , double s )
{
 //numeri da generare, media e varianza

 vector<double> y( qq );
 vector<double> x( qq );
 x = lehmer( qq );
 for( int i = 0 ; i < x.size() ; i = i + 2 ) {
  y[ i ] = sqrt( - 2 * log( x [ i ] ) ) * cos( 2 * Pi * x[ i + 1 ] );
  y[ i ] = s * y[ i ] + m; 
        
  if( i + i <= qq ) {
   y[ i + 1 ] = sqrt( - 2 * log( x[ i ] ) ) * sin( 2 * Pi * x[ i + 1 ] ); 
   y[ i + 1 ] = s * y[ i + 1 ] + m;
   }
  }

 return( y );
 }

//delay time
void sleep1( unsigned int mseconds )
{
 clock_t goal = mseconds + clock();
 while( goal > clock() );
 }

void wait( int seconds )
{
 clock_t endwait = clock() + seconds * CLOCKS_PER_SEC;
 while( clock() < endwait );
 }

vector<double> randomgen( int q )
{
 double qdouble = q;
 double qmezzi = qdouble/2;
 double qterzi = qdouble/3;
 vector<double> numeri( q );
 vector<double> numeripart1;
 vector<double> numeripart2;
 vector<double> numeripart3;
     
 srand( time( 0 ) );
 int radq = int( log( qdouble ) );
 int m1, m2, m3;
 int qt = int( q / 3 );
 int dueqt = int( 2 * ( q / 3 ) );
 m1 = rand() % ( qt - radq ) + radq;
 m2 = rand() % ( dueqt - m1 - radq ) + ( m1 + radq );
 m3 = rand() % ( q - m2 - radq - radq ) + ( m2 + radq );

 int s1 = rand() % radq + 1;
 int s2 = rand() % radq + 1;
 int s3 = rand() % radq + 1;

 int npart1 = floor( qterzi );
 int npart2 = floor( qterzi );
 int npart3 = q - npart1 - npart2;

 numeripart1.resize( npart1 );
 numeripart2.resize( npart2 );
 numeripart3.resize( npart3 );

 numeripart1 = boxmuller( npart1 , m1 , s1 );
 numeripart2 = boxmuller( npart2 , m2 , s2 );
 numeripart3 = boxmuller( npart3 , m3 , s3 );

 for( int i = 0 ; i < npart1 ; i++ )
  numeri[ i ] = int( numeripart1[ i ] );

 for( int i = 0 ; i < npart2 ; i++ )
  numeri[ i + npart1 ] = int( numeripart2[ i ] );

 for( int i = 0 ; i < npart3 ; i++ )
  numeri[ i + npart1 + npart2 ] = int( numeripart3[ i ] );
    
 //correzione numeri negativi, nulli e superiori a q
 sort( numeri.begin() , numeri.end() );
 reverse( numeri.begin() , numeri.end() );
 for( int i = 0 ; i < numeri.size() ; i++ ) {
  if( numeri[ i ] <= 0 )
   numeri[ i ] = 1;
  else
   if( numeri[ i ] > q )
    numeri[ i ] = q;
  }

 return( numeri );
 }

// scrivi files

void filesgen( vector<double> b , vector<double> c , int q , string nome )
{
 ofstream lp;

 //file .lat
 string nome1 = nome + ".lat";

 lp.open( nome1.c_str() , ios_base::out );
 lp << q << endl;

 // prima riga: costi fissi c_ij
 for( int i = 0 ; i < q ; i++ )
  lp << c[ i ] << " ";

 lp << "\n";

 //seconda riga: costi variabili a_ij
 for( int i = 0 ; i < q ; i++ )
  lp << b[ i ] << " ";

 lp<<"\n";
     
 lp.close();
 }    

// main

int main( int argc , char *argv[] )
{
 if( argc < 4 ) {
  cout << "Usage is:" << endl ;
  cout << "gauss q Coeff nrand" << endl ;
  cout << "  q     numero risorse."<<endl;
  cout << "  Coeff coefficiente moltiplicativo costi."<<endl;
  cout << "  nrand numero istanza."<<endl;
  return( 1 );
  }

 int nrand; //numero istanze casuali da generare
 int Bmax; //max intero da generare
 bool base;
 vector<double> b;
 vector<double> c;

 int q = atoi( argv[ 1 ] );
 int Coeff = atoi( argv[ 2 ] );

 Bmax = Coeff * q;

 nrand = atoi( argv[ 3 ] );
    
 srand( time( 0 ) );

 //alpha generation
 vector<double> alpha( q );
 alpha[ 0 ] = 1.0 / q;
 for( int j = 1 ; j < q ; j++ )
  alpha[ j ] = alpha[ j - 1 ] + ( 1.0 / q );
        
 //vettore costi fissi
 c.resize( 0 );
 c.resize( q );
 c = randomgen( q );

 b.resize( 0 );
 b.resize( q );
 b[ 0 ] = rand() % int( c[ 0 ] ) + 1;      

 double maxval;
 for( int j = 1 ; j < b.size() ; j++ ) {
  double maxval = max( c[ 0 ] - c[ j ] , b[ j - 1 ] );
  int inf_extr = int( maxval );
  int maxval2 = int( alpha[ j ] * ( Bmax - inf_extr ) + inf_extr );
  int sup_extr = rand() % ( maxval2 - inf_extr ) + inf_extr;
  if( inf_extr == sup_extr )
   b[ j ] = inf_extr;
  else
   b[ j ] = rand() % ( sup_extr - inf_extr ) + inf_extr;
  }

 for( int j = 1 ; j < q ; j++ )
  if( c[ j ] == c[ j - 1 ] )
   b[ j ] = b[ j - 1 ];
        
 for( int j = 1 ; j < q ; j++ )
  if( b[ j ] == b[ j - 1 ] )
   c[ j ] = c[ j - 1 ];

 // controllo non dominanza
 for( int j = 0 ; j < b.size() ; j++)
  if( c[ j ] + b[ j ] < c[ 0 ] ) {
   cout << "L'istanza contiene elementi dominati" << endl;
   return( 0 );
   }

 char filename[ 100 ];
 sprintf( filename , "radar-%s-%s-a-%s" , argv[1] , argv[2] , argv[3] );

 string nome1;
 nome1 = filename;

 filesgen( b , c , q , nome1 );

 //2 seconds delay between successive generation to guarantee randomness
 sleep1( 1000 );

 // istanza casuale di tipo 1 (b_i "bassi")

 b.resize( 0 );
 b.resize( q );
 b = randomgen(q);
 reverse( b.begin() , b.end() );

 c.resize( 0 );
 c.resize( q );
 c[ 0 ] = Coeff * b[ q - 1 ];      
 for( int j = 1 ; j < b.size() ; j++ ) {
  int inf_extr = int( c[ 0 ] - b[ j ] );
  int sup_extr = int( c[ j - 1 ] );
  c[ j ] = rand() % ( sup_extr - inf_extr ) + inf_extr + 1;
  }

 for( int j = 1 ; j < q ; j++ )
  if( c[ j ] == c[ j - 1 ] )
   b[ j ] = b[ j - 1 ];

 for( int j = 1 ; j < q ; j++ )
  if( b[ j ] == b[ j - 1 ] )
   c[ j ] = c[ j - 1 ];

 for( int j = 0 ; j < b.size() ; j++ )
  if( c[ j ] + b[ j ] < c[ 0 ] ) {
   cout << "L'istanza contiene elementi dominati" << endl;
   return( 0 );
   }

 sprintf( filename , "radar-%s-%s-b-%s" , argv[ 1 ] , argv[ 2 ] , argv[ 3 ] );

 nome1 = filename;

 filesgen( b , c , q , nome1 );

 return( 0 );
 }
    
