/******************************************************************************
 *  This program produces a randomly-generated instance of the Sensor Placement
 *  Problem modeled over a PARTITION instance.
 *
 *  Enrico Grande, May 28, 2009
 *
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main( int argc , char** argv )
{
 if( argc < 2 ) {
  printf( "Usage is: generatore nometest \n" );
  return( 1 );
  }

 int n , seed , MAXVAL , i;
 FILE *fin, *fout;
 double *weight, *weight2;
 double sum;
 char filename[ 100 ];

 sprintf( filename , "%s.prm" , argv[ 1 ] );
 fin = fopen( filename , "r" );
 fscanf( fin , "%d" , &n );
 fscanf( fin , "%d" , &MAXVAL );
 fscanf( fin , "%d" , &seed );
 fclose( fin );

 weight  = (double*) calloc( n , sizeof(double) );
 weight2 = (double*) calloc( n , sizeof(double) );
      
 srand( seed );
 for( i = 0 ; i < n ; i++ )
  weight[ i ] = rand();

 printf( "Proposed seed %d \n", (int) weight[ n - 1 ] );

 sum = 0;
 for( i = 0 ; i < n ; i++ ) {
  weight[ i ] = weight[ i ] * MAXVAL / RAND_MAX;
  sum += weight[ i ];
  }

 for( i = 0 ; i < n  ; i++ )
  weight2[ i ] = sum * sum / ( 4 * weight[ i ] );

 sprintf( filename , "%s.rdr" , argv[ 1 ] );
 fout = fopen( filename , "w" );

 fprintf( fout , "%d\n" , n );

 for( i = 0 ; i < n ; i++ )
  fprintf( fout , "%f " , weight[ i ] );
 fprintf( fout , "\n" );

 for( i = 0 ; i < n ; i++ )
  fprintf( fout , "%f " , weight2[ i ] );
 fprintf( fout , "\n" );

 fclose( fout ); 

 return( 0 );
 }
