package filter;
use strict;

BEGIN{
    require Exporter;
    use vars qw(@ISA @EXPORT);
    @ISA = qw(Exporter);
    @EXPORT = qw(&decibel &lowpass &predict);
}

=pod
Restituisce il rapporto in decibel
PARAMETRI:
- il numeratore del rapporto;
- il denominatore del rapporto;
Restituisce:
il valore in dB
Eccezioni:
se il denominatore  uguale a zero;
se il rapporto ha valore inferiore ad 1;
Test:
Verifica numerica 2138, 1000 -> 3.300077 (manuale NE)
=cut
sub decibel {
    ( $_[1] != 0 ) || die "Division by zero\n";
    my $rate = $_[0] / $_[1];
    ( $rate >= 0 ) || die "Negative rate\n";
    return 10 * ( log $rate ) / ( log 10 );
}

=pod
Un filtro passabasso:
Dato il valore attuale ed il valore filtrato precedente, restituisce
il valore filtrato attuale
PARAMETRI:
- il valore attuale;
- il valore precedente;
- il fattore di filtro.
Valore restituito:
Il valore filtrato attuale
Eccezioni:
Il fattore di filtro  uguale a 0
Test:
lowpass(12,14,4)=13.5
=cut
sub lowpass {
#    print "Filtro:", $_[0], " ", $_[1], " ", $_[2], "\n";
    ( $_[2] != 0 ) || die "Filter factor can't be zero!\n";
    ( defined $_[1] ) || return $_[0];
    return ( ( $_[1] * ($_[2] - 1) ) + $_[0] ) / $_[2];
}

=pod
Un filtro predittore. Calcola prima il differenziale in valore assoluto
del valore in ingresso rispetto al valore acquisito, quindi calcola 
il rapporto (in dB) rispetto al differenziale atteso, l'indicatore di
picco, ed aggiorna con il nuovo indicatore di picco il valore del 
differenziale atteso. Se il risultato  superiore ad un valore di 
soglia, la funzione termina. Altrimenti il valore acquisito viene 
utilizzato per calcolare la prossima predizione del valore. 
Se la soglia per l'indicatore di picco  indefinito, il valore 
acquisito viene sempre utilizzato per calcolare la prossima predizione
del valore.
La funzione gestisce il transitorio iniziale, in cui le due predizioni
sono indefinite.
Il valore acquisito, i valori predetti ed i parametri dei diversi
filtri vengono passati entro un'unico array @state, passato per 
puntatore:
$state->[0]: valore acquisito
$state->[1]: predizione valore
$state->[2]: predizione differenziale
$state->[3]: parametro per il filtro passabasso per la predizione
             del valore  
$state->[4]: parametro per il filtro passabasso per la predizione
             del differenziale  
$state->[5]: parametro di soglia per il rapporto tra i
             differenziali
PARAMETRI:
- un puntatore all'array descritto sopra.
Valore restituito:
- l'indicatore di picco
=cut
sub predict {
    my $stateref=$_[0];
    my $peak;
# Calcolo della previsione del differenziale
# eseguita solo se esistono gi valori precedenti
#    my $x; for ($x=0; $x<6; $x++) { 
#	print $stateref->[$x]; print " "; 
#    } 
	if ( defined $stateref->[1] ) {
	    if ( ( defined $stateref->[2]) &&
		 ( $stateref->[2] != 0 ) ) {
		$peak=decibel( abs($stateref->[0]-$stateref->[1]),
			       $stateref->[2]);
	    }
		$stateref->[2]=abs lowpass(
				      $stateref->[0]-$stateref->[1],
				      $stateref->[2],
				      $stateref->[4]);
	}
    if ( ( ! defined $stateref->[5] ) ||
	 ( ! defined $peak )        || 
	 ( $peak < $stateref->[5] ) ) { 
    $stateref->[1] = lowpass($stateref->[0],
			     $stateref->[1],
			     $stateref->[3]);
    }
    return $peak;
}

1;















