#!/usr/bin/perl -w
=head1 
BUGS: quando non c'e' il server produce errori strani...
=cut
use strict;
use filter;
use Carp;
use Socket;
use Sys::Hostname;
require 'sys/syscall.ph';

$SIG{INT} = sub {
    warn "Attesa per lo sganciamento del server...";
    select(undef,undef,undef,5.5);
    exit(0);
};

=pod
variabili di appoggio (da spostare)
=cut
my $remote_addr;
=pod
variabili globali
$time: un array che rappresenta il timestamp della round in corso
       (secondi e frazioni di secondo)
=cut
=pod
variabili di configurazione:
MAXLOST = massimo numero di perdite di BENCHMARK ammesse;
TIMEOUT = timeout sulla ricezione dell'ACK (secs);
=cut
    my $MAXLOST=10;
    my $TIMEOUT=0.5;
my $time = pack("LL", ());

sub pushtime {
=pod
Inserisce in un array dei tempi il tempo attuale
=cut
    syscall(&SYS_gettimeofday, $time, 0) != -1 
	|| die "gettimeofday: $!";
    my @time = unpack("LL",$time);
    push @{$_[0]}, $time[0] + ( $time[1] /1000000 );
}

sub select_Server {
    my $rin = '';
    vec($rin,fileno(Server),1) = 1;
    return select($rin, undef, $rin, $_[0]);
}

=pod
La subroutine round esegue una singola istanza del protocollo
di benchmark.
PARAMETRI:
 - la dimensione del pacchetto (in ottetti);
 - il timeout sul roundtrip BENCHMARK - ACK (in secondi);
 - il numero massimo di tentativi di spedizione del BENCHMARK;
VALORE restituito:
 - uno stack contenente i tempi rilevati; in testa c'e' il numero di
   pacchetti di BENCHMARK perduti;
ECCEZIONI (die):
 - Perdita ripetuta di pacchetti di BENCHAMRK oltre la soglia;
 - Altri eventi che pregiudicano il funzionamento del tool;
=cut
sub round {
=pod
l'array che contiene i tempi rilevati, come reali
=cut
    my @times;
    my @rtimes;
    my $rtimes;
=pod
il conteggio degli errori di sincronizzazione
=cut
    my $error_count=0;
=pod
Formato del pacchetto di OPEN (lungh: 16 ottetti = 128 bit):
- un intero corto per il tipo di pacchetto (0=OPEN, 1=BENCHMARK);
- un intero corto senza segno (16 bit) per la dimensione del 
  pacchetto di benchmark;
- due interi lunghi senza segno (32 bit x 2) per il timestamp 
  dell'esperimento;
- un intero corto senza segno per il timeout sulla ricezione dell'ACK
  in millisecondi;
- un intero corti per successive estensioni
=cut
    my $time = pack("LL", ());
    syscall(&SYS_gettimeofday, $time, 0) != -1
	|| die "gettimeofday: $!";
    my @time = unpack("LL",$time);
=pod
I pacchetti di OPEN e BENCHMARK vengono preparati prima di entrare
nella sezione con temporizzazione critica
=cut
    my $receiver_timeout=int((1.1*$_[2]*$_[1])*1000);
    my $openpkt = 
	pack("SSLLSS",0,$_[0],$time[0],$time[1],
                      $receiver_timeout,0);
    my $benchmarkpkt = 
	pack("SSLLSSa$_[0]", 1, $_[0], $time[0],$time[1],
                             $receiver_timeout,0);
    eval {     
# PALETTO
	pushtime \@times; 
	defined(send(Server, $openpkt, 0, $remote_addr))
	    || die "send OPEN: $!";
    };
    if ($@) { die "$@"; }
    do {
#PALETTO
        eval {
	    pushtime \@times; 
	    defined(send(Server, $benchmarkpkt, 0, $remote_addr))
		|| die "send BENCHMARK: $!";
	};
	if ($@) { die "$@"; }
	eval {
	    ( select_Server($_[1]) >= 1 )
		|| die "alarm\n";
	    defined(recv(Server, $rtimes, 16, 0))
		|| die "$!";
#PALETTO
	    pushtime \@times;
	};
	if ($@) {
	    die "Errore alla receive dell'ACK: $@" 
		unless $@ eq "alarm\n";	
	    $error_count++;
	    warn "\aLost benchmark #$error_count\n";
	    pop @times;
	}
    } until ( defined( $rtimes ) || $error_count >= $MAXLOST );
=pod
inserimento in coda dei dati dal partner
=cut
    defined( $rtimes ) 
	|| die "Too many lost BENCHMARK packets, stopped " ;
    my @time_list = unpack("dd",$rtimes);
    push @times, @time_list;
=pod
in testa all'array restituito mette il numero di tentativi falliti
=cut
    push @times, $error_count;
    return @times;
}

=pod
La subroutine "analisi" valuta i risultati di una singola
istanza del protocollo di benchmark, e aggiorna la tabella con
i valori.
PARAMETRI:
- l'array dei tempi rilevati;
- i puntatore all'array con i tempi precedenti e quelli filtrati
- la dimensione del pacchetto di benchmark;
=cut
sub analisi {
    my $x = 0;      # indice dei tempi
    my $k = pop @_; # dimensione del pacchetto di benchmark
    my $history=pop @_; # puntatore all'array con i dati storici
    my $picco;
    my $regolare=1;
# Compute half roundtrip (for debugging only)
    my $HR = ( $_[2] - $_[0] - ($_[4] - $_[3]) ) / 2;
    ${$history}[0][0] = $HR;
    predict($history->[0]);
# Compute clock offset
    my $OS = $_[3] - $_[0] - $HR;
    ${$history}[1][0] = $OS;
    predict $history->[1]; 
# Compute one-way bandwidth
    my $BW = ($k / (2**10)) / ( $_[4] - $_[3] );
    ${$history}[2][0] = $BW;
    predict $history->[2];
# Compute jitter asymmetry 
    my $JA;
    if ( defined ${$history}[1][1] ) {
        eval {
              $JA = decibel( ( $_[3] - $_[0] ) - ${$history}[1][1],
                             ( $_[2] - $_[4] ) + ${$history}[1][1]);
        };
        if ( defined $JA ) {
            ${$history}[3][0] = $JA;
            predict($history->[3]);
        }
    }
}

( $ARGV[2] ) 
    || die "Usage: probe <BENCHMARK size> <# rounds> <server>\n";
# dimensione del pacchetto di benchmark;
my $k = $ARGV[0];
# numero di istanze del protocollo eseguite
my $N = $ARGV[1];
# Estremi del server remoto (meglio nella riga di comando)
my $remote_host=$ARGV[2];   # indirizzo
my $remote_port=22000;      # porta
my $i;      # contatore general purpose;
my @t;      # buffer per i risultati del singolo esperimento
my @rv=( [ undef,undef,undef, 10, 10, 2],
	 [ undef,undef,undef, 10, 10, 2],
	 [ undef,undef,undef, 10, 10, undef],
	 [ undef,undef,undef, 10, 10, undef],
	 [ undef,undef,undef, 10, 10, undef]);
# L'output non viene bufferizzato
$| = 1;

# Costruzione del socket UDP locale
socket(Server, PF_INET, SOCK_DGRAM, getprotobyname('udp'))
    || die "socket: $!";
# bind del socket su una porta locale scelta dal kernel
my $iaddr = gethostbyname(hostname());
bind(Server, sockaddr_in(0, $iaddr))                          
    || die "bind: $!";

# costruzione dell'indirizzo dell'host remoto
my $remote_ipaddr = inet_aton($remote_host)    
    || die "unknown host";
$remote_addr = sockaddr_in($remote_port, $remote_ipaddr)
    || die "boh!";
# Costruisce il tempo "di riferimento" all'inizio dell'esperimento
# Utile per la visualizzazione dei dati...
my $Tref;
{
    my $Tinit = pack("LL", ());
    syscall(&SYS_gettimeofday, $Tinit, 0) != -1 
	|| die "gettimeofday: $!";
    my @Tinit = unpack("LL",$Tinit);
    $Tref = $Tinit[0] + ( $Tinit[1] /1000000 );
}
# Stampa dell'intestazione del rapporto: tutte le voci cominciano con
# uno spazio!
my $ora=localtime;
=pod
Numero cumulativo di BENCHMARK perduti durante la sessione
=cut
my $LB;
printf " DATE = %s;\n", $ora;
print " SERVER = $remote_host;\n";
print " PACKET SIZE = $k;\n";
print " PACKET NUMBER = $N;\n";
print " ACK TIMEOUT = $TIMEOUT;\n";
print " MAX LOST BENCHMARK = $MAXLOST;\n";

# Loop di misure in stretta successione
for (my $i=0; $i<$N; $i++) {
# Singola misura
    eval { @t = round($k,$TIMEOUT, $MAXLOST) };
  CASE: {
      ( $@ =~ "" ) && do {
	  last CASE;
      };
      die "$@"; 
  };
# Tempi
    my $x=0;
    my $lost_benchmarks = pop @t;
    $LB += $lost_benchmarks;
    printf("***** new round *****\n");
    printf ("Lost %d\n", $lost_benchmarks);
    for (@t) { printf "T%d %f\n", $x, $_; $x++ };
    if ( $lost_benchmarks == 0 ) {
=pod 
Analisi dei dati della singola misura
=cut
	analisi @t, \@rv, $k; 
=pod
Stampa del rapporto sulla singola istanza

Nella prima iterazione, i valori differenziali e filtrati non
possono essere calcolati, e l'array $rv risulta quindi
monodimensionale, causando problemi al filtro per la visualizzazione
dei dati. Quindi per la prima iterazione non vengono visualizzati i
risultati dell'analisi.
=cut
        if ( $i > 0 ) {
	    my @statparms = (
			     ["HR","(sec)"],
			     ["OS","(sec)"],
			     ["BW","(Kbyte/sec)"],
			     ["JA","(dB)"],
			     );
	    my $j=0;
	    my @elem;
	    for (@statparms) {
		printf "%f - %s = ", $t[0]-$Tref, $$_[0];
		foreach my $elem (@{$rv[$j]}) {
		    if  ( defined($elem) ) {
			printf "%f ",$elem;
		    } else {
			print "0.0 ";
		    }
		}
		print " $$_[1]\n";
		$j++;
	    }
	    printf "%f - LB = %d\n", $t[0]-$Tref, $LB;
	}
    } else {
	printf "%f - Round discarded: lost %d BENCHMARKs\n", 
	       $t[0]-$Tref, 
	       $lost_benchmarks;
    }
}






















