#!/usr/bin/perl -Tw
use strict;
use Carp;
use Socket;
require 'sys/syscall.ph';

# Estremi del server
my $port=22000;

sub pushtime {
    my $time = pack("LL", ());
    syscall(&SYS_gettimeofday, $time, 0) != -1 
	|| die "gettimeofday: $!";
    my @time = unpack("LL",$time);
    push @{$_[0]}, $time[0] + ( $time[1] /1000000 );
}

sub select_Server {
    my $rin = '';
    vec($rin,fileno(Server),1) = 1;
    return select($rin, undef, $rin, $_[0]);
}

sub logmsg { print "$0 $$: @_ at ", scalar localtime, "\n" }

# Costruzione del socket UDP
socket(Server, PF_INET, SOCK_DGRAM, getprotobyname('udp')) 
    || die "socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, pack("l", 1)) 
    || die "setsockopt: $!";
# bind del socket sulla porta "nota"
bind(Server, sockaddr_in($port, INADDR_ANY)) 
    || die "bind: $!";

# l'array che contiene i tempi rilevati, come reali
my @times;
my $n;

logmsg "server pronto sulla porta $port\a";
=pod
    Il loop principale  innescato da una select sulla porta destinata
    al protocollo.
=cut
LOOP: while ( select_Server(undef) >= 1 ) {
     my $openmsg; 
     my $benchmarkmsg;
     my ( $TsB, $TmB );
=pod
Il pacchetto viene ricevuto, e viene controllato il campo del
tipo, che deve corrispondere a 0 (OPEN). Quindi si preleva 
dal pacchetto la dimensione del pacchetto di BENCHMARK, ed il
timeout da applicare alla ricezione del BENCHMARK, calcolato
dal mittente.
=cut
     my $remote_addr = recv(Server, $openmsg, 16, 0);
     my ( $type, $k, $Ts, $Tm, $timeout ) = unpack("SSLLSS",$openmsg);
     $timeout = $timeout/1000;
     ( $type == 0 )
	 || ( warn "OPEN message shuffle\a", pop @times, next LOOP );
=pod     
Attesa del pacchetto di BENCHMARK: registrazione del timestamp 
prima della select, ed al termine della recvfrom. L\'alternativa
di leggere il timestamp dopo la select  stata provata e scartata 
(documentato nel commento alla versione.
=cut
 eval {
# PALETTO
	 pushtime \@times;
	 ( select_Server($timeout) >= 1 )
	     || die "alarm\n";
	 defined(recv(Server, $benchmarkmsg, $k, 0))
	     || die "$!";
# PALETTO
	 pushtime \@times;
	 alarm 0;
     };
     if ($@) {
# In caso di errori di sincronizzazione reinizializza il server
	 if ( $@ eq "alarm\n" ) {
	     warn "Errore di sincronizzazione in attesa del BENCHMARK\a" 
	     }
	 else {
	     warn "Errore alla receive del BENCHMARK\a";
	 };
	 next LOOP;
     };
# Verifica del timestamp del pacchetto di BENCHMARK
     ( $type, $k, $TsB, $TmB ) = unpack("SSLLSS",$benchmarkmsg);
     ( ( $type == 1 ) && 
       ( $Ts == $TsB) && 
       ( $Tm == $TmB) )
     || die "BENCHMARK message shuffle: can't handle that\a";
# Qui ci vorrebbe un altro paletto?    pushtime \@times;
 defined(send(Server, pack("dd",@times), 0, $remote_addr))
	 || die "send: $!";
# Svuota lo stack dei tempi rilevati
    while ( pop @times ) {};
    next LOOP;
 }

   









